/*****************************************************************************
*  LPC81x blinky program for MicroCore48 rev B board
*
*  1. Use SCT timer to generate a 10 msec timer tick (interrupt driven).
*  2. Toggle P0_7 every 200 msec
*****************************************************************************/
#include "LPC8xx.h"

extern void SCT_Init(void);

void SCT_IRQHandler (void)
{                                                  // SCT Interrupt Handler (10 msec)
  static uint8_t cnt = 0;

    if (++cnt > 20)                                // 20 * 10 msec = 200 msec
    {
        cnt = 0;
        LPC_GPIO_PORT->NOT0 = (1 << 7);            // toggle pin P0_7
    }
    LPC_SCT->EVFLAG = 0x00000001;                  // clear event 0 flag
}

int main (void) 
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 6);         // enable clock to GPIO
    LPC_GPIO_PORT->DIR0       |= (1 << 7);         // configure P0.7 (LED) as output

    SCT_Init();                                    // Initialize SCT

    while (1)                                      // loop forever
    {
    }
}
